---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, date, affichage de la date
---

# Comment insérer la date dans un document ?

Cette page traite de la question de l'affichage de la [date](wpfr:Date). 
Si vous cherchez l'affichage de l'heure, 
vous pouvez consulter la question "[](/3_composition/texte/mots/inserer_l_heure_dans_un_document)".


## Avec les commandes de base

La commande `\today` permet de récupérer la date au moment de la compilation du document. 
Le format est cependant par défaut en anglais.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Nous sommes le  \today.
\end{document}
```


## Avec l'extension <ctanpkg:babel>

L'extension <ctanpkg:babel> permet d'adapter le comportement de `\today`
à d'autres langues, en particulier le français avec l'option `french` 
(mise ici dans l'appel de la classe de document pour qu'elle influence 
toutes les extensions).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Nous sommes le  \today.
\end{document}
```


## Avec l'extension <ctanpkg:datetime2>

L'extension <ctanpkg:datetime2>, de Nicola Talbot, 
fournit de nombreux outils de mise en forme de la date. 
L'extension <ctanpkg:babel> doit etre chargée avant <ctanpkg:datetime2> ; 
toutefois, pour bénéficier de formats spécifiques à la langue, 
l'option `useregional` doit être retenue. 
Voici un exemple montrant son utilisation, avec un cas de modification de format.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[useregional]{datetime2}

\begin{document}
Nous sommes le \today{}.

\DTMsetdatestyle{ddmmyyyy} % afficher les dates en format "jj mm aaaa"
\DTMsetup{datesep=/}       % ajout du séparateur "/ dans les dates
Nous sommes le \today{}.
\end{document}
```

Cette extension remplace <ctanpkg:datetime> et sa [documentation](texdoc:datetime2) explique 
comment passer de <ctanpkg:datetime> à <ctanpkg:datetime2>.