---
myst:
  html_meta:
    keywords: LaTeX,moteur de césure,coupure de mots,motifs de césure,hyphenation patterns
---
# Comment fonctionne la césure en TeX ?

La césure, c'est la coupure des mots en fin de ligne, comme ici dans « bou-gie » :

```
\documentclass{article}
\usepackage[T1]{fontenc}
  \usepackage[width=5cm]{geometry}
  \usepackage[french]{babel}
  \pagestyle{empty}
\begin{document}
\Large
Longtemps, je me suis couché de bonne heure.
Parfois, à peine ma bougie éteinte, mes yeux
se fermaient si vite que je n’avais pas
le temps de me dire : \og{}Je m’endors.\fg{}
\end{document}
```

Elle est utilisée dans la plupart des livres et journaux, et doit suivre quelques règles pour rester discrète. Quand elle est faite à de mauvais emplacements dans les mots, elle ralentit la lecture et oblige le lecteur à revenir en arrière, par exemple ici :

```
\documentclass{article}
\usepackage[T1]{fontenc}
  \usepackage[width=4.6cm]{geometry}
  \usepackage[french]{babel}
  \pagestyle{empty}
\begin{document}
\Large
Longtemps, je me su\-is couché de bonne heu\-re.
Parfois, à peine ma bo\-ugie éteinte, mes y\-eux
se fermaient si vit\-e que je n’avais pas
le temps de me dire : \og{}Je m’endors.\fg{}
\end{document}
```

Les règles de césure sont déterminées par le bon sens, mais aussi par la culture, et pour une même langue, on peut avoir des styles différents selon le pays --- par exemple, les styles de césure de l'anglais en Grande-Bretagne et aux États-Unis sont très différents. Par conséquent, un logiciel de mise en page utilisé dans le monde entier doit pouvoir adapter ses règles de césure.

Le système de césure de TeX est plutôt réputé pour sa qualité. Il a été conçu au départ par Frank Liang, dans le cadre de [](/3_composition/langues/cesure/coupures_de_mots_accentues) »)

Les ensembles de motifs de césure sont généralement dérivés de l'analyse d'une liste de césures valides. Pour TeX et LaTeX, ce processus de dérivation a été fait à l'aide de l'outil <ctanpkg:patgen>, mais le commun des mortels n'a pas besoin de savoir faire ça.

Pour chaque langue utilisée, les motifs doivent avoir été installés pour que le moteur TeX puisse s'en servir. Pour modifier l'ensemble des motifs de césure reconnus par un système TeX ou [XeTeX](/1_generalites/glossaire/xetex), [une réinstallation partielle est nécessaire](/3_composition/langues/utiliser_une_nouvelle_langue_avec_babel) (notez que [LuaTeX](/1_generalites/glossaire/luatex) assouplit cette contrainte).

TeX fournit deux commandes à l'utilisateur pour le contrôle de la césure : `\language` (qui sélectionne un style de césure), et `\hyphenation` (qui donne des instructions explicites au moteur de césure, généralement pour les cas particuliers ou les nouveaux mots, annulant l'effet des motifs chargés par ailleurs). L'utilisateur ordinaire de LaTeX n'a pas à se soucier de la commande `\language`, puisque l'extension <ctanpkg:babel> s'en occupe pour lui ; l'utilisation de `\hyphenation` est expliqué [sur la page évoquant les problèmes de césure](/3_composition/langues/cesure/la_cesure_ne_fonctionne_pas).

:::{sources}
- [How does hyphenation work in TeX?](faquk:FAQ-hyphen)
- [Coupure de mots en fin de ligne](http://www.visezjuste.uottawa.ca/pages/orthographe/coupure_des_mots.html) (Université d'Ottawa).
:::
