---
myst:
  html_meta:
    keywords: LaTeX,documentation,symboles,caractères,detexify
---

# Où trouver ce symbole ?


Cette section détaille la manière d'obtenir des caractères, autrement
dit des éléments présents dans une police de caractères (elle ne traite
pas des [logos](/3_composition/texte/symboles/logos/start) et des
[polices de caractères](/3_composition/texte/symboles/polices/start)),
ce qui inclut souvent des symboles : on utilisera donc ici les deux
termes indifféremment.

Il existe un large éventail de symboles disponibles avec (La)TeX et
nombre d'entre eux ne sont pas représentés (ou même mentionnés) dans
les livres sur (La)TeX. Diverses solutions compensent en bonne partie
cette situation.


## Des listes de symboles

Ces listes sont données à la question "[](/3_composition/texte/symboles/polices/polices_de_symboles)".


## Un outil de recherche graphique

Si une liste des symboles est une ressource intéressante, il n'est
jamais facile d'y trouver un symbole particulier.
[Detexify](http://detexify.kirelabs.org/classify.html), un outil web de
recherche graphique, vous propose une zone sur laquelle vous dessinez
avec votre souris le symbole auquel vous pensez. Lorsque vous avez fini
de dessiner, l'outil tente de faire correspondre votre esquisse avec
les symboles dont il a connaissance. Le processus de correspondance est
assez bon mais il peut être intéressant de faire plusieurs essais. Cet
outil dispose d'équivalents sur les appareils mobiles : vous pouvez dès
lors dessiner vos symboles avec vos doigts (ce qui sera sans doute moins
difficile).


## Cette FAQ

Deux sections de cette FAQ traitent de ce sujet :

-   cette section ;
-   la section [Symboles mathématiques](/4_domaines_specialises/mathematiques/symboles/start).

Les questions de la présente question sont listées ci-après.


### Comment obtenir certains caractères courants ?

-   les [accents](/3_composition/texte/symboles/caracteres/accents_divers) ;
-   l'[e dans l'o](/3_composition/texte/symboles/caracteres/glyphe_e_dans_l_o) « œ » ;
-   les [guillemets](/3_composition/texte/symboles/caracteres/guillemets) "«" et "»" ;
-   l'[arobase](/3_composition/texte/symboles/caracteres/arobe) `@` ;
-   le [degré](/3_composition/texte/symboles/caracteres/le_degre) `°` ;
-   le [numéro](/3_composition/texte/symboles/caracteres/numero) `nº` ou `Nº` ;
-   l'[euro](/3_composition/texte/symboles/caracteres/caractere_euro) `€` 
    ou le [franc français](/3_composition/texte/symboles/caracteres/caractere_franc) « ₣ » ;
-   les [tirets](/3_composition/texte/symboles/caracteres/tiret) `_`, `–`, `—` et `-` ;
-   les [points de suspension](/3_composition/texte/symboles/caracteres/caractere_points_de_suspension) `…` ;
-   le [point exclarrogatif](/3_composition/texte/symboles/caracteres/interrobang) `‽` ;
-   les [pour-cent, pour-mille,     pour-dix-mille](/3_composition/texte/symboles/caracteres/pour-cent),
    soit `%`, `‰` et `‱` ;
-   la [contre-oblique](/3_composition/texte/symboles/caracteres/backslash)
    ou barre oblique inverse `\` ;
-   le [tilde](/3_composition/texte/symboles/caracteres/caractere_tilde) `~` ;
-   les [copyright, trademark et registered](/3_composition/texte/symboles/caracteres/copyright), soit ©, ™ et ® ;
-   les [symboles des licences Creative Commons](/3_composition/texte/symboles/caracteres/creative_commons).


### Comment obtenir certains chiffres ?

-   [](/3_composition/texte/symboles/caracteres/chiffres_elzeviriens)
-   [](/3_composition/texte/symboles/caracteres/chiffres_entoures)


### Comment obtenir d'autres caractères et symboles ?

-   [](/3_composition/texte/symboles/caracteres/phonetique)
-   [](/3_composition/texte/symboles/caracteres/caractere_paragraphe)
-   [](/3_composition/texte/symboles/caracteres/symboles_male_et_femelle)
-   [](/3_composition/texte/symboles/caracteres/symboles_astronomiques)
-   [](/3_composition/texte/symboles/caracteres/symbole_de_radioactivite)
-   [](/3_composition/texte/symboles/caracteres/symboles_electroniques)


### Autres questions

-   [](/3_composition/texte/symboles/caracteres/caracteres_reserves) (tels `#`, `&`)
-   [](/3_composition/texte/symboles/caracteres/mes_caracteres_ont_disparu)
-   [](/3_composition/texte/symboles/caracteres/symboles_manquants)


## Table de caractères accessibles par une commande ou une ligature

Cette table ne donne que les symboles accessibles sans appel
d'extension. Elle est sans doute incomplète.

```{tabularcolumns} >{\RaggedRight}\Y{0.28}\Y{0.16}\Y{0.56}
```

| Commande                           | Caractère | Remarque                                                                                   |
|:-----------------------------------|:----------|:-------------------------------------------------------------------------------------------|
| `\aa`                              | å         |                                                                                            |
| `\AA`                              | Å         |                                                                                            |
| `\ae`                              | æ         |                                                                                            |
| `\AE`                              | Æ         |                                                                                            |
| `\copyright`                       | ©         | Voir "[](/3_composition/texte/symboles/caracteres/copyright)"                              |
| `\dag`                             | †         |                                                                                            |
| `\ddag`                            | ‡         |                                                                                            |
| `\dots`                            | …         | Voir "[](/3_composition/texte/symboles/caracteres/caractere_points_de_suspension)"         |
| `\i`                               | ı         |                                                                                            |
| `\j`                               | ȷ         |                                                                                            |
| `\l`                               | ł         |                                                                                            |
| `\L`                               | Ł         |                                                                                            |
| `\o`                               | ø         |                                                                                            |
| `\O`                               | Ø         |                                                                                            |
| `\oe`                              | œ         | Voir "[](/3_composition/texte/symboles/caracteres/glyphe_e_dans_l_o)"                      |
| `\OE`                              | Œ         | Voir "[](/3_composition/texte/symboles/caracteres/glyphe_e_dans_l_o)"                      |
| `\P`                               | ¶         | Voir "[](/3_composition/texte/symboles/caracteres/caractere_paragraphe)"                   |
| `\pounds` ou `\textsterling`       | £         | La livre sterling.                                                                         |
| `\S`                               | §         |                                                                                            |
| `\ss`                              | ß         | L'eszett (lettre allemande) minuscule.                                                     |
| `\textasciicircum`                 | ^         |                                                                                            |
| `\textasciitilde`                  | \~        | Voir "[](/3_composition/texte/symboles/caracteres/caractere_tilde)"                        |
| `\textbackslash`                   | \\        | Voir "[](/3_composition/texte/symboles/caracteres/backslash)"                              |
| `\textbar`                         | \|        |                                                                                            |
| `\textbullet`                      | •         |                                                                                            |
| `\textdegree`                      | °         | Voir "[](/3_composition/texte/symboles/caracteres/le_degre)"                               |
| `\texteuro`                        | €         | Voir "[](/3_composition/texte/symboles/caracteres/caractere_euro)"                         |
| `\textgreater`                     | \>        | La saisie est directe en mode mathématique.                                                |
| `\textless`                        | \<        | La saisie est directe en mode mathématique.                                                |
| `\textperiodcentered`              | ·         |                                                                                            |
| `\textpertenthousand`              | ‱         | Voir "[](/3_composition/texte/symboles/caracteres/pour-cent)"                              |
| `\textperthousand`                 | ‰         | Voir "[](/3_composition/texte/symboles/caracteres/pour-cent)"                              |
| `\textregistered`                  | ®         | Voir "[](/3_composition/texte/symboles/caracteres/copyright)"                              |
| `\texttrademark`                   | ™         | Voir "[](/3_composition/texte/symboles/caracteres/copyright)"                              |
| `\textvisiblespace`                | ␣         | Voir "[](/3_composition/texte/mots/visualiser_les_espaces)"                                |
| `\{`                               | {         | Voir "[](/3_composition/texte/symboles/caracteres/caracteres_reserves)"                    |
| `\}`                               | }         | Voir "[](/3_composition/texte/symboles/caracteres/caracteres_reserves)"                    |
| `\%`                               | \%        | Voir "[](/3_composition/texte/symboles/caracteres/pour-cent)"                              |
| `\&`                               | &         | Voir "[](/3_composition/texte/symboles/caracteres/caracteres_reserves)"                    |
| `\$`                               | \$        | Voir "[](/3_composition/texte/symboles/caracteres/caracteres_reserves)"                    |
| `\#`                               | \#        | Voir "[](/3_composition/texte/symboles/caracteres/caracteres_reserves)"                    |
| ``?` `` ou `\textquestiondown`     | ¿         |                                                                                            |
| ``!` `` ou `\textexclamdown`       | ¡         |                                                                                            |
| `\_` ou `\textunderscore`          | \_        | Le tiret bas, voir "[](/3_composition/texte/symboles/caracteres/tiret)"                    |
| `---` ou `\textemdash`             | ---       | Le tiret cadratin, voir "[](/3_composition/texte/symboles/caracteres/tiret)"               |
| `--` ou `\textendash`              | --        | Le tiret demi-cadratin, voir "[](/3_composition/texte/symboles/caracteres/tiret)"          |
| `` ` `` ou `\textquoteleft`        | ‘         |                                                                                            |
| `'` ou `\textquoteright`           | ’         | L'apostrophe typographique.                                                                |
| `''` ou `\textquotedblleft`        | “         | *Il s'agit de deux caractères `'` et pas d'un caractère `"`.*                              |
| ``` `` ``` ou `\textquotedblright` | ”         |                                                                                            |
| \<\<                               | «         | Guillemet français ouvrant, voir "[](/3_composition/texte/symboles/caracteres/guillemets)" |
| \>\>                               | »         | Guillemet français fermant, voir "[](/3_composition/texte/symboles/caracteres/guillemets)" |

:::{sources}
[Where can I find the symbol for\...](faquk:FAQ-symbols)
:::
```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```
