# Contributing

[![Chinese version](./assets/chinese.svg)](./contributing-zh.md)

:tada: First off, thanks for taking the time to contribute! :tada:

The following is a set of guidelines for contributing to BIThesis.

These are mostly guidelines, not rules. Use your best judgment,
and feel free to propose changes to this document in a pull request.

## Guidance

**[I don't want to read this whole thing, I just have a small question!!!](#join-our-QQ-chat-group)**

|                 | For Users                                | For Developers                                 |
| --------------- | ---------------------------------------- | ---------------------------------------------- |
| Have a Question | [QQ Chat Group](#join-our-QQ-chat-group) | [QQ Chat Group](#join-our-QQ-chat-group)       |
| Bug Report      | [QQ Chat Group](#join-our-QQ-chat-group) | [GitHub - Issues](#bug-report-on-github)       |
| Feature Request | [QQ Chat Group](#join-our-QQ-chat-group) | [QQ Chat Group](#join-our-QQ-chat-group)       |
| Pull Request    |                                          | [GitHub - Pull Request](#pull-request-process) |

## Join Our QQ Chat Group

We provide a [QQ Chat Group][QQ chat group invitation]
with **a bunch of active maintainers** and **a friendly community**
to give helpful advice **if you have any questions**.

[![Join on QQ Chat Group](https://img.shields.io/badge/QQ%E7%BE%A4-737548118-green)](https://jq.qq.com/?_wv=1027&k=KYDrmS5z)

> **Note**
> There are no detailed rules about how to ask question, just provide enough information and
> rethink before write.

## Bug Report on GitHub

If you can locate the bug or provide more detailed information, you may
_[report an issue here][issue reporting link]_.

## Pull Request Process

Pull Requests are welcomed!

The following steps will help you finish a pull request.

1. Fork this repo.
2. `git clone` your forked repo.
3. Make changes until the bug is fixed.
4. Commit your changes.
5. Create a pull request with related information.
6. Keep in touch with further discussion and refine.

For more information, refer to the
_[GitHub Help](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests)_.

[QQ chat group invitation]: https://jq.qq.com/?_wv=1027&k=KYDrmS5z
[issue reporting link]: https://github.com/BITNP/BIThesis/issues/new
