/* misc.c - C4P Utilities
   Tims-stamp: " "

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>

#include "common.h"

static void check_c_file_size (void);

static unsigned c_file_count;
static unsigned c_file_number;

static FILE *name_file;

extern symbol_t *prog_symbol;

static void
generate_file_header (void)

{
  out_form ("/* %s */\n", pascal_file_name);
}

void
open_name_file (void)

{
  char name_file_name[20];
  sprintf (name_file_name, "%s.nam", prog_symbol->s_repr);
#if 0
  if ((name_file = fopen (name_file_name, "w")) == 0)
    c4p_error ("can't open manifest file %s", name_file_name);
#endif
}

void
close_name_file (void)

{
#if 0
  fclose (name_file);
#endif
}

void
open_header_file (void)

{
  char h_file_name[100];
  if (one_c_file && c_file_name)
    sprintf (h_file_name, "%s.h", c_file_name);
  else
    sprintf (h_file_name, "%s.h", prog_symbol->s_repr);
  open_file (1, h_file_name);
  redir_file (1);
  generate_file_header ();
}

extern char *include_filename;

void
begin_new_c_file (const char *file_name, int is_main)

{
  char cfile_name[100];

  sprintf (cfile_name, "%s.c", file_name);

#if 0
  printf ("creating %s\n", cfile_name);
#endif

  if (c_file_count++ == 0)
    open_file (0, cfile_name);
  else
    reopen_file (0, cfile_name);

  redir_file (0);
  generate_file_header ();
  out_form ("#define EXTERN%s\n\n", is_main ? "" : " extern");
  out_s ("#include <");
  out_s (include_filename);
  out_s (">\n");
  if (c_file_name)
    out_form ("#include \"%s.h\"\n\n", c_file_name);
  else
    out_form ("#include \"%s.h\"\n\n", prog_symbol->s_repr);
}

static void
check_c_file_size (void)

{
  char name[9];

  if (c_file_count == 0 ||
      (!one_c_file && c_file_line_count + 20 > max_lines_per_c_file))
    {
      c_file_number++;
      if (one_c_file)
	{
	  if (c_file_name)
	    {
	      begin_new_c_file (c_file_name, 1);
	      return;
	    }
	  else
	    sprintf (name, "%s", prog_symbol->s_repr);
	}
      else
	sprintf (name, "%s%03u",
		 (c_file_name ? c_file_name : prog_symbol->s_repr),
		 c_file_number);
      begin_new_c_file (name, one_c_file);
    }
}

extern unsigned curly_brace_level;
extern unsigned block_level;

char current_fast_vars[200];

void
forget_fast_vars ()

{
  *current_fast_vars = 0;
}

void
remember_fast_var (const char *s)

{
  if (strstr (current_fast_vars, s) == 0)
    {
      strcat (current_fast_vars, " ");
      strcat (current_fast_vars, s);
    }
}

void
declare_fast_var_macro (unsigned routine_handle)

{
  char *v = strtok (current_fast_vars, " ");
  redir_file (H_FILE_NUM);
  out_form ("\n#define _C4P_FAST_VARS_%u ", routine_handle);
  macroizing++;
  while (v)
    {
      symbol_t *sym = lookup (v);
      if (sym)
	{
	  out_form ("register %s %s_c4p_fast_%s_%u = %s;\n",
		    (sym->s_translated_type ? sym->s_translated_type : "FIXME"),
		    (sym->s_type == ARRAY_NODE ? "*" : ""),
		    sym->s_repr,
		    routine_handle,
		    sym->s_repr);
	}
      v = strtok (0, " ");
    }
  macroizing--;
  out_s ("\n");
  redir_file (C_FILE_NUM);
}

void
begin_routine (prototype_node *proto,
	       unsigned handle)

{
  check_c_file_size ();
  out_s ("\n");
  block_level++;
  mark_symbol_table ();
  mark_string_table ();
  mark_type_table ();
  generate_routine_head (proto);
  out_s ("\n");
  out_s ("{\n");
  curly_brace_level++;
  if (n_fast_vars)
    {
      out_form ("_C4P_FAST_VARS_%u\n", handle);
      forget_fast_vars ();
    }
#if 0
  fprintf (name_file, "%u %s\n", handle, proto -> name -> s_repr);
#endif
}

void
end_routine (unsigned handle)

{
  extern int n_fast_vars;

  unmark_type_table ();
  unmark_string_table ();
  unmark_symbol_table ();
  block_level--;
  curly_brace_level--;
  out_s ("}\n");
  if (n_fast_vars)
    declare_fast_var_macro (handle);
}

char *
strcpye (char *s1,
	 const char *s2)

{
  while ((*s1++ = *s2++) != 0)
    ;
  return (--s1);
}
