#include "Win32Util.h"
#include "Registry.h"
#include "FileDirectory.h"
#include "KeyValFile.h"
#include "TPM.h"
#include "TeXInstall.h"


bool TPM::ConfigurePerl()
{
    bool bRet = IsInstalled();

    if (IsInstalled()) {
        CString sPerlPath1 = ConcatPath(g_sInstallRootDir, "xemtex\\perl\\lib");
        CString sPerlPath2 = ConcatPath(g_sInstallRootDir, "xemtex\\perl\\site\\lib");
        CString sPerlPath = sPerlPath1 + ";" + sPerlPath2;
        theEnvironment.SetValue("PERL5LIB", sPerlPath);
    }

    return bRet;
}

bool TPM::ConfigureIMagick()
{
#define IMAGICK_GLOBAL_REGENTRY "SOFTWARE\\ImageMagick"
#define IMAGICK_USER_REGENTRY "Software\\ImageMagick"
#define IMAGICK_VERSION "5.5.6"
#define IMAGICK_QUANTUMDEPTH_STRING "Q16"
#define IMAGICK_QUANTUMDEPTH 0x00000010

    bool bRet = IsInstalled();

    if (IsInstalled()) {
        CRegistry theRegistry;
        HKEY hkRegRoot = (g_bAllUsers ? HKEY_LOCAL_MACHINE : HKEY_CURRENT_USER);
        if (theRegistry.Connect(hkRegRoot) == TRUE) {
            CString sRegKey = (g_bAllUsers ? IMAGICK_GLOBAL_REGENTRY : IMAGICK_USER_REGENTRY);
            sRegKey = ConcatPath(sRegKey, IMAGICK_VERSION "\\" IMAGICK_QUANTUMDEPTH_STRING, '\\');
            CString sBinDir = ConcatPath(g_sInstallRootDir, "bin\\win32", '\\');
            
            if (theRegistry.Create(sRegKey) == FALSE ) {
                theLog("Registry: can't create ImageMgick subkey (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("BinPath", (LPCTSTR)sBinDir ) == FALSE) {
                theLog("Registry: can't set BinPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("ConfigurePath", (LPCTSTR)ConcatPath(sBinDir, "config", '\\')) == FALSE) {
                theLog("Registry: can't set ConfigurePath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("LibPath", (LPCTSTR)sBinDir ) == FALSE) {
                theLog("Registry: can't set LibPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("ModulesPath", (LPCTSTR)ConcatPath(sBinDir, "modules\\coders", '\\')) == FALSE) {
                theLog("Registry: can't set ModulesPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            
            
            sRegKey = (g_bAllUsers ? IMAGICK_GLOBAL_REGENTRY : IMAGICK_USER_REGENTRY);
            sRegKey = ConcatPath(sRegKey, "Current", '\\');

            if (theRegistry.Create(sRegKey) == FALSE ) {
                theLog("Registry: can't create ImageMagick current subkey (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("Version", IMAGICK_VERSION) == FALSE) {
                theLog("Registry: can't set Version value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("QuantumDepth", IMAGICK_QUANTUMDEPTH ) == FALSE) {
                theLog("Registry: can't set QuantumDepth value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("BinPath", (LPCTSTR)sBinDir ) == FALSE) {
                theLog("Registry: can't set BinPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("ConfigurePath", (LPCTSTR)ConcatPath(sBinDir, "config", '\\')) == FALSE) {
                theLog("Registry: can't set ConfigurePath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("LibPath", (LPCTSTR)sBinDir ) == FALSE) {
                theLog("Registry: can't set LibPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
            if (theRegistry.SetValue("ModulesPath", (LPCTSTR)ConcatPath(sBinDir, "modules\\coders", '\\')) == FALSE) {
                theLog("Registry: can't set ModulesPath value (Error %d)\n",
                       GetLastError());
                goto exit_3;
            }
        exit_3:
            theRegistry.Close();
        }
    }
    else {
        theLog("!!!Can't connect to registry for configuring ImageMagick!!!\n");
    }
    return bRet;
}

bool TPM::ConfigureGs()
{
    bool bRet = IsInstalled();

    if (IsInstalled()) {
#define GHOSTSCRIPT_GLOBAL_REGENTRY "SOFTWARE\\GNU Ghostscript"
#define GHOSTSCRIPT_USER_REGENTRY "Software\\GNU Ghostscript"
#define GHOSTSCRIPT_VERSION "7.07"

        CRegistry theRegistry;
        HKEY hkRegRoot = (g_bAllUsers ? HKEY_LOCAL_MACHINE : HKEY_CURRENT_USER);
        if (theRegistry.Connect(hkRegRoot) == TRUE) {
            CString sRegKey = (g_bAllUsers ? GHOSTSCRIPT_GLOBAL_REGENTRY : GHOSTSCRIPT_USER_REGENTRY);
            sRegKey = ConcatPath(sRegKey, GHOSTSCRIPT_VERSION, '\\');
            CString sGsDll = ConcatPath(g_sInstallRootDir, "bin\\win32\\gsdll32.dll", '\\');
            CString sGsLib1 = ConcatPath(g_sInstallRootDir, "xemtex\\gsfonts");
            CString sGsLib2 = ConcatPath(g_sInstallRootDir, "xemtex\\gslib");
            CString sGsLib = sGsLib1 + ";" + sGsLib2;
            
            if (theRegistry.Create(sRegKey) == FALSE ) {
                theLog("Registry: can't create Ghostscript subkey (Error %d)\n",
                       GetLastError());
                goto exit_4;
            }
            if (theRegistry.SetValue("GS_DLL", (LPCTSTR)sGsDll) == FALSE) {
                theLog("Registry: can't set GS_DLL value (Error %d)\n",
                       GetLastError());
                goto exit_4;
            }
            if (theRegistry.SetValue("GS_LIB", (LPCTSTR)sGsLib) == FALSE) {
                theLog("Registry: can't set GS_LIB value (Error %d)\n",
                       GetLastError());
                goto exit_4;
            }
        exit_4:
            theRegistry.Close();
        }
    }
    return bRet;
}

static bool NeedToEditMapFileList(TPMSet &vMap)
{
    bool bRet = false;

    // Check if we need to change the current list of map files
    // First if we are doing a full installation
    if (g_eInstallType == INSTALL_FULL) {
        bRet = true;
    }
    // Second, compare the list of installed package with the
    // new packages.
    else if (g_eInstallType == INSTALL_MAINTENANCE) {
        POSITION pos;
        CString sKey, sTPMKey;
        TPM *tpm = NULL, *tpmSource = NULL, *tpmLocal = NULL;
        pos = vMap.GetStartPosition();
        while (pos) {
            vMap.GetNextAssoc(pos, sKey, tpm);
            sTPMKey = tpm->GetKey();
            if (g_vSourceTPM.Lookup(sTPMKey, tpmSource)
                && tpmSource->IsInstalled()) {
                // This one has been installed
                // need to rewrite because if the package is newer
                // the list might have changed
                bRet = true;
                break;
            }
        }
    }
    return bRet;
}

bool TPM::ConfigureDvipdfm()
{
    bool bRet = IsInstalled();
    CString src, dst;
    dst = ConcatPath(g_sVarTexmf, "dvipdfm\\config\\config");
    if (IsInstalled()) {
        src = ConcatPath(g_sTexmfMain, "dvipdfm\\config\\config-win32", '\\');
        bRet = bRet && SafeCopyFile(src, dst, true, true);
    }
    if (NeedToEditMapFileList(g_vDvipdfmMap)) {
        theLog("Dvipdfm configuration: selecting installed map files.\n");
        // Configuring map files
        KeyValFile kConfig;
        if (kConfig.Open(dst)) {
            CString sMapLine;
            kConfig.RawReplace("f ", "", true, 0);
            // 
            POSITION pos;
            CString sKey, sTPMKey;
            TPM *tpm, *tpmSource, *tpmLocal;
            pos = g_vDvipdfmMap.GetStartPosition();
            while (pos) {
                g_vDvipdfmMap.GetNextAssoc(pos, sKey, tpm);
                // Weird ! we need to be sure we are talking to the ones 
                // in the g_sSourceTPM array
                sTPMKey = tpm->GetKey();
                if ((g_vSourceTPM.Lookup(sTPMKey, tpmSource) && tpmSource->IsInstalled())
                    || (g_vInstalledTPM.Lookup(sTPMKey, tpmLocal))) {
                    sMapLine = "f " + sKey;
                    kConfig.RawReplace("", sMapLine , true);
                    theLog("Adding `%s'\n", sMapLine);
                }
            }
            kConfig.Commit();
            kConfig.Close();
            theLog("Closing %s.\n", dst);
        }
        else {
            theLog("!!!Failed to configure map files for %s.\n", m_sKey);
        }
    }
    return bRet;
}

bool TPM::ConfigureDvips()
{
    bool bRet = IsInstalled();
    CString src, dst;
    src = ConcatPath(g_sTexmfMain, "dvips\\config\\config.ps");
    dst = ConcatPath(g_sVarTexmf, "dvips\\config\\config.ps");
    if (IsInstalled()) {
        bRet = bRet && SafeCopyFile(src, dst, true, true);
    }
    if (NeedToEditMapFileList(g_vDvipsMap)) {
        theLog("Dvipsk configuration: selecting installed map files.\n");
        // Configuring map files
        KeyValFile kConfig;
        if (kConfig.Open(dst)) {
            CString sMapLine;
            kConfig.RawReplace("p +", "", true, 0);
            // 
            POSITION pos;
            CString sKey, sTPMKey;
            TPM *tpm, *tpmSource, *tpmLocal;
            pos = g_vDvipsMap.GetStartPosition();
            while (pos) {
                g_vDvipsMap.GetNextAssoc(pos, sKey, tpm);
                // Weird ! we need to be sure we are talking to the ones 
                // in the g_sSourceTPM array
                sTPMKey = tpm->GetKey();
                if ((g_vSourceTPM.Lookup(sTPMKey, tpmSource) && tpmSource->IsInstalled())
                    || (g_vInstalledTPM.Lookup(sTPMKey, tpmLocal))) {
                    sMapLine = "p +" + sKey;
                    kConfig.RawReplace("", sMapLine , true);
                    theLog("Adding `%s'\n", sMapLine);
                }
            }
            kConfig.Commit();
            kConfig.Close();
            theLog("Closing %s.\n", dst);
        }
        else {
            theLog("!!!Failed to configure map files for %s.\n", m_sKey);
        }
    }
    return bRet;
}

bool TPM::ConfigurePdftex()
{
    bool bRet = IsInstalled();
    CString src, dst;
    src = ConcatPath(g_sTexmfMain, "pdftex\\config\\pdftex.cfg");
    dst = ConcatPath(g_sVarTexmf, "pdftex\\config\\pdftex.cfg");
    if (IsInstalled()) {
        bRet = bRet && SafeCopyFile(src, dst, true, true);
    }
    if (NeedToEditMapFileList(g_vPdfTeXMap)) {
        theLog("PdfTeX configuration: selecting installed map files.\n");
        // Configuring map files
        KeyValFile kConfig;
        if (kConfig.Open(dst)) {
            CString sMapLine;
            // Remove all map lines
            kConfig.RawReplace("map +", "", true, 0);
            // 
            POSITION pos;
            CString sKey, sTPMKey;
            TPM *tpm, *tpmSource, *tpmLocal;
            pos = g_vPdfTeXMap.GetStartPosition();
            while (pos) {
                g_vPdfTeXMap.GetNextAssoc(pos, sKey, tpm);
                // Weird ! we need to be sure we are talking to the ones 
                // in the g_sSourceTPM array
                sTPMKey = tpm->GetKey();
                if ((g_vSourceTPM.Lookup(sTPMKey, tpmSource) && tpmSource->IsInstalled())
                    || (g_vInstalledTPM.Lookup(sTPMKey, tpmLocal))) {
                    sMapLine = "map +" + sKey;
                    kConfig.RawReplace("", sMapLine , true);
                    theLog("Adding `%s'\n", sMapLine);
                }
            }
            kConfig.Commit();
            kConfig.Close();
            theLog("Closing %s.\n", dst);
        }
        else {
            theLog("!!!Failed to configure map files for %s.\n", m_sKey);
        }
    }
    return bRet;
}

bool TPM::ConfigureTeX4ht()
{
    bool bRet = IsInstalled();
    if (IsInstalled()) {
        // Special case for tex4ht.env
        // No need to edit it after that. I won't bother if people prefer
        // to use IMagick.
        CString src, dst;
        CString sTeX4htCfg("tex4ht-win32.env");

        // It should have been copied there.
        src = ConcatPath(g_sTexmfMain, ConcatPath("tex4ht\\base", sTeX4htCfg), '\\');
        dst = ConcatPath(g_sVarTexmf, "tex4ht\\base\\tex4ht.env");
        bRet = bRet && SafeCopyFile(src, dst, true, true);
#if 0
        if (FileExists(dst)){
            // Be safe in locating convert.exe !
            if (sTeX4htCfg.Find("imagick") > -1) {
                CString sIMagickDir = g_sInstallRootDir;
                GetParentDirectory(sIMagickDir);
                ConcatPath(sIMagickDir, "ImageMagick");	  
                KeyValFile kTeX4ht;
                kTeX4ht.Open((LPCTSTR)dst);
                bRet = bRet && kTeX4ht.RawReplace("@imbindir@", sIMagickDir);
                bRet = bRet && kTeX4ht.Commit();
                kTeX4ht.Close();
            }
        }
#endif
    }
    return bRet;
}

bool TPM::ConfigureTeXBasic()
{
    static const char *g_confFiles[] = {
        "web2c\\texmf.cnf",
        "web2c\\mktex.cnf",
        "web2c\\fmtutil.cnf",
        "web2c\\updmap.cfg"
    };

    bool bRet = IsInstalled();

    if (IsInstalled()) {
        ASSERT(! g_sInstallRootDir.IsEmpty());
        ASSERT(! g_sTexmfMain.IsEmpty());
    
        CString src, dst, sTmp;
        CString sRootDir = g_sInstallRootDir;
        
        // Copy the configuration files
        for (int i = 0; i < sizeof(g_confFiles)/sizeof(g_confFiles[0]); i++) {
            src = ConcatPath(g_sTexmfMain, g_confFiles[i]);
            dst = ConcatPath(g_sVarTexmf, g_confFiles[i]);
            if (FileExists(src)){
                SafeCopyFile(src, dst, true, true);
            }
        }

        if (! g_bDryRun) {
            // and edit $VARTEXMF/web2c/texmf.cnf
            KeyValFile kTexmfCnf;
            kTexmfCnf.Open(ConcatPath(g_sVarTexmf, "web2c\\texmf.cnf"));
      
            sRootDir.Replace('\\', '/');
            if (sRootDir.Right(1) != "/")
                sRootDir += "/";
      
            sTmp = g_sTexmfMain;
            sTmp.Replace('\\', '/');
            if (sTmp.Find((LPCTSTR)sRootDir) == 0) {
                sTmp.Replace((LPCTSTR)sRootDir, "$SELFAUTOPARENT/");
            }
            kTexmfCnf.Replace("TEXMFMAIN", sTmp);
      
            if (g_sTexmfLocal.IsEmpty()) {
                kTexmfCnf.Comment("TEXMFLOCAL");
            }
            else {
                kTexmfCnf.Uncomment("TEXMFLOCAL");
                sTmp = g_sTexmfLocal;
                sTmp.Replace('\\', '/');
                if (sTmp.Find((LPCTSTR)sRootDir) == 0) {
                    sTmp.Replace((LPCTSTR)sRootDir, "$SELFAUTOPARENT/");
                }
                kTexmfCnf.Replace("TEXMFLOCAL", sTmp);
                if (! ::DirectoryExists(g_sTexmfLocal))
                    ::CreateDirectoryPath(g_sTexmfLocal);
            }
      
            if (g_sTexmfHome.IsEmpty()) {
                kTexmfCnf.Comment("HOMETEXMF");
            }
            else {
                CString sHome;
                kTexmfCnf.Uncomment("HOMETEXMF");
                sTmp = g_sTexmfHome;
                sTmp.Replace('\\', '/');
                if (FindHomeDir(sHome)) {
                    if (sHome.Right(1) != "/" && sHome.Right(1) != "\\")
                        sHome += "/";
                    sHome.Replace('\\', '/');
                    if (sTmp.Find((LPCTSTR)sHome) == 0) {
                        sTmp.Replace((LPCTSTR)sHome, "$HOME/");
                    }
                }
                kTexmfCnf.Replace("HOMETEXMF", sTmp);
                if (! ::DirectoryExists(g_sTexmfHome))
                    ::CreateDirectoryPath(g_sTexmfHome);
            }
      
            if (g_sTexmfExtra.IsEmpty()) {
                kTexmfCnf.Comment("TEXMFEXTRA");
            }
            else {
                kTexmfCnf.Uncomment("TEXMFEXTRA");
                sTmp = g_sTexmfExtra;
                sTmp.Replace('\\', '/');
                if (sTmp.Find((LPCTSTR)sRootDir) == 0) {
                    sTmp.Replace((LPCTSTR)sRootDir, "$SELFAUTOPARENT/");
                }
                kTexmfCnf.Replace("TEXMFEXTRA", sTmp);
	
                if (! ::DirectoryExists(g_sTexmfExtra))
                    ::CreateDirectoryPath(g_sTexmfExtra);
            }
      
            if (g_sVarTexmf.IsEmpty()) {
                kTexmfCnf.Comment("VARTEXMF");
            }
            else {
                kTexmfCnf.Uncomment("VARTEXMF");
                sTmp = g_sVarTexmf;
                sTmp.Replace('\\', '/');
                if (sTmp.Find((LPCTSTR)sRootDir) == 0) {
                    sTmp.Replace((LPCTSTR)sRootDir, "$SELFAUTOPARENT/");
                }
                kTexmfCnf.Replace("VARTEXMF", sTmp);
            }
      
            if (g_sVarTexFonts.IsEmpty()) {
                kTexmfCnf.Comment("VARTEXFONTS");
            }
            else {
                kTexmfCnf.Uncomment("VARTEXFONTS");
                sTmp = g_sVarTexFonts;
                sTmp.Replace('\\', '/');
                if (sTmp.Find((LPCTSTR)g_sVarTexmf) == 0) {
                    sTmp.Replace((LPCTSTR)g_sVarTexmf, "$VARTEXMF");
                }
                kTexmfCnf.Replace("VARTEXFONTS", sTmp);
                if (! ::DirectoryExists(g_sVarTexFonts))
                    ::CreateDirectoryPath(g_sVarTexFonts);
            }
      
            CString sTexmf = "{";
            if (g_sTexmfHome.IsEmpty() == FALSE) {
                sTexmf += "$HOMETEXMF,";
            }
            if (g_sVarTexmf.IsEmpty() == FALSE) {
                sTexmf += "!!$VARTEXMF,";
            }
            if (g_sTexmfLocal.IsEmpty() == FALSE) {
                sTexmf += "!!$TEXMFLOCAL,";
            }
            if (g_sTexmfMain.IsEmpty() == FALSE) {
                sTexmf += "!!$TEXMFMAIN,";
            }
            if (g_sTexmfExtra.IsEmpty() == FALSE) {
                sTexmf += "!!$TEXMFEXTRA,";
            }
            if (sTexmf.GetAt(sTexmf.GetLength() - 1) == ',') {
                sTexmf.SetAt(sTexmf.GetLength() - 1, '}');
            }
            else {
                sTexmf += "}";
            }
            kTexmfCnf.Replace("TEXMF", sTexmf);
      
            CString sTexmfDBs = "$TEXMF";
            if (_strnicmp((LPCTSTR)g_sVarTexFonts, 
                          "$VARTEXMF", strlen("$VARTEXMF")) != 0
                && _strnicmp((LPCTSTR)g_sVarTexFonts, 
                             g_sVarTexmf, g_sVarTexmf.GetLength()) != 0) {
                sTexmfDBs += ";$VARTEXFONTS";
            }
            kTexmfCnf.Replace("TEXMFDBS", sTexmfDBs);
      
            kTexmfCnf.Comment("TEMP");
      
            kTexmfCnf.Commit();
            kTexmfCnf.Close();
        }
    }
    // Rebuild updmap.cfg
    {
        CString dst = ConcatPath(g_sVarTexmf, "web2c\\updmap.cfg");
        if (NeedToEditMapFileList(g_vUpdMap) || NeedToEditMapFileList(g_vUpdMixedMap)) {
            theLog("Updmap configuration: selecting installed map files.\n");
            // Configuring map files
            KeyValFile kConfig;
            if (kConfig.Open(dst)) {
                CString sMapLine;
                // Remove all map lines
                kConfig.RawReplace("Map", "", true, 0);
                kConfig.RawReplace("MixedMap", "", true, 0);
                // 
                POSITION pos;
                CString sKey, sTPMKey;
                TPM *tpm, *tpmSource, *tpmLocal;
                pos = g_vUpdMap.GetStartPosition();
                while (pos) {
                    g_vUpdMap.GetNextAssoc(pos, sKey, tpm);
                    // Weird ! we need to be sure we are talking to the ones 
                    // in the g_sSourceTPM array
                    sTPMKey = tpm->GetKey();
                    if ((g_vSourceTPM.Lookup(sTPMKey, tpmSource) && tpmSource->IsInstalled())
                        || (g_vInstalledTPM.Lookup(sTPMKey, tpmLocal))) {
                        sMapLine = "Map " + sKey;
                        kConfig.RawReplace("", sMapLine , true);
                        theLog("Adding `%s'\n", sMapLine);
                    }
                }

                pos = g_vUpdMixedMap.GetStartPosition();
                while (pos) {
                    g_vUpdMixedMap.GetNextAssoc(pos, sKey, tpm);
                    // Weird ! we need to be sure we are talking to the ones 
                    // in the g_sSourceTPM array
                    sTPMKey = tpm->GetKey();
                    if ((g_vSourceTPM.Lookup(sTPMKey, tpmSource) && tpmSource->IsInstalled())
                        || (g_vInstalledTPM.Lookup(sTPMKey, tpmLocal))) {
                        sMapLine = "MixedMap " + sKey;
                        kConfig.RawReplace("", sMapLine , true);
                        theLog("Adding `%s'\n", sMapLine);
                    }
                }
                kConfig.Commit();
                kConfig.Close();
                theLog("Closing %s.\n", dst);
            }
            else {
                theLog("!!!Failed to configure map files for %s.\n", m_sKey);
            }
        }
    }
    
    return bRet;
}
/* Local Variables:      */
/* mode: c++             */
/* c-basic-offset: 4     */
/* indent-tabs-mode: nil */
/* End:                  */

