// Python extension module
#include <Python.h>
#include "ListDir.h"
#include "debug.h"

////////////////////////////////////////////////////////////////////////
class FilterPy : public ListDir::Filter
{
 public:
   FilterPy(PyObject* filterObj = 0,
            const std::string& matcher = "") : 
            _filterObj(filterObj), 
            _matcher(matcher) {}
   virtual ~FilterPy() {DHERE;}
 private:
   bool operator()(const std::string& s);
   PyObject*          _filterObj;
   const std::string  _matcher;
}; // FilterPy


////////////////////////////////////////////////////////////////////////
bool FilterPy::operator()(const std::string& s)
{  
   DHERE;
   bool  matched = true;
   return matched;
} // FilterPy::operator()


////////////////////////////////////////////////////////////////////////
static PyObject*  lsdCreate(PyObject* self, PyObject* args, PyObject* kwArgs)
{  DHERE;  
   static char*       argNames[] = {"path", 
                                    "basefilt", "fullfilt",
                                    "basematcher", "fullmatcher",
                                    0};
   enum {Base, Full, N_Filt};
   typedef PyObject*  PyObjectPtr;
   PyObjectPtr        ret = 0, 
                      pyFilt[N_Filt];
                      pyFilt[Base] = pyFilt[Full] = 0;
   char*              matcherNames[N_Filt];
                      matcherNames[Base] = matcherNames[Full] = "match";
   char*              path = 0;
DHERE;   
   if (PyArg_ParseTupleAndKeywords(args, kwArgs, "s|OOss", argNames,
                                   &path, 
                                   &pyFilt[Base], &pyFilt[Full],
                                   &matcherNames[Base], &matcherNames[Full]))
   { DHERE;
      ListDir::Filter*  flt[N_Filt];
      for (unsigned i = 0;  i != N_Filt;  ++i)
      {  DPR0("i="<<i);
         PyObjectPtr  pOF = pyFilt[i];
         flt[i] = (pOF 
                   ? new FilterPy(pOF, matcherNames[i]) 
                   : new ListDir::Filter);
      }
      ListDir* pListDir = new ListDir(path, *flt[Base], *flt[Full]);
      ret = PyCObject_FromVoidPtr(pListDir, &ListDir::sDel);
      delete flt[0];
      delete flt[1];
   } DHERE;
   return ret;
} // lsdCreate

////////////////////////////////////////////////////////////////////////
static PyObject*  lsdNItems(PyObject* self, PyObject* args)
{  DHERE;
   PyObject*  ret = 0;
   PyObject*  objListDir = 0;
   if (PyArg_ParseTuple(args, "O", &objListDir))
   {
      const ListDir* pLSD = (const ListDir*)PyCObject_AsVoidPtr(objListDir);
      long  n = pLSD->nItems();
      ret = PyInt_FromLong(n);
   }
   if (ret == 0)
   {
      Py_INCREF(Py_None);
      ret = Py_None;
   }
   return ret;
} // lsdNItems



////////////////////////////////////////////////////////////////////////
static PyObject*  lsdGet(PyObject* self, PyObject* args)
{
   PyObject*  ret = 0;
   PyObject*  objListDir = 0;
   int        i;
   if (PyArg_ParseTuple(args, "Oi", &objListDir, &i))
   {
      const ListDir* pLSD = (const ListDir*)PyCObject_AsVoidPtr(objListDir);
      int       n = pLSD->nItems();
      if (i < n)
      {
         const char*  entry = pLSD->item(i).c_str();
         ret = PyString_FromString(entry);
      }
   }
   if (ret == 0)
   {
      Py_INCREF(Py_None);
      ret = Py_None;
   }
   return ret;
} // lsdGet

////////////////////////////////////////////////////////////////////////
static PyMethodDef   
       lspath_methods[] = 
       {
          {"create", (PyCFunction)&lsdCreate, METH_VARARGS | METH_KEYWORDS},
          {"nitems", (PyCFunction)&lsdNItems, METH_VARARGS},
          {"get",    (PyCFunction)&lsdGet,    METH_VARARGS},
          {0, 0}
       };

////////////////////////////////////////////////////////////////////////
PyMethodDef* lsdMethods()
{
   return lspath_methods;
} // lsdMethods

////////////////////////////////////////////////////////////////////////
extern "C" void init_lsd()
{
   DHERE;
   Py_InitModule("_lsd", lspath_methods);
} // initspath
