# -*- python -*-
# $Id: canvases.py,v 1.9 2000/12/25 20:45:06 yotam Exp $

# standard
import sys;
import GDK;
import gnome.ui;
# local
import tfmpkl;
import tfm;
import pk;
import pkcanvas;

import gtkgoods; # gflush
# import gdkgoods; # printEvent

###########
# constants

#- pixel sizes
extpad = 12;
intpad = 3;
gridwidth = 1;
selectWidth = 2;
dimWidth = 4;

# display mode
displayNatural = 0;
displayFit     = 1;

class Q:
   def __init__(self, n=0, d=1):
      self.num = n;   # numerator
      self.denom = d; # denominator 
   def mult(self, m):
      r = (self.num * m + self.denom - 1)/self.denom;
      return r;
      
def initGDK():
   pkcanvas.initgdk();

# Multiply scaled numbers and divide by power of 2
# Using Python's LongInt
def n1n2n3_div2p(n1=1, n2=1, n3=1, p=0):
   n1n2n3 = ((n1 + 0L) * n2) * n3; # Adding 0L makes it LongInt computation.
   twop   = (1L << p);
   q = n1n2n3 / twop;
   return q;

def Long2int(l):
   return int(min(l, 0x7fffffff));

# For rounding.
halfScaledPower = 1L << (20 + 20 + 16 - 1);
scaledPower = 1L << (20 + 20 + 16);

#####################################
# Table of font faces canvas subclass
class Faces(gnome.ui.GnomeCanvas):
   def __init__(self, tfmpkFont):
      gnome.ui.GnomeCanvas.__init__(self);
      self.connect('event', self.callback);
      # self.root().connect('event', self.callback);
      self._font = tfmpkFont;
      initGDK();
      self._pixbufs = pkcanvas.createpixbufs(self._font.pk().obj());
      self.calcMinMax();
      self.naturalItems = []
      self.naturalCItems = []
      self.fitItems = []
      self.fitCItems = []
      self._selectItem = None;
      # self._selectedChar = self._font.pk().charfirst();
      # self._selectedChar = -1
      self.draw(tfmpkFont.pk().charfirst());
      # self.select(self._font.pk().charfirst());

   # Now find the maximal space needed for a character.
   # Condider the bitmap and the escapements.
   # We need the origin to be included and positioned in a cosistent place.
   def calcMinMax(self):
      pk = self._font.pk();
      xmin = xmax = ymin = ymax = 0;
      for c in xrange(pk.charfirst(), pk.charlast()+1):
         if pk.haschar(c):
            (w, h) = (pk.bitmapwidth(c), pk.bitmapheight(c));
            # pk.voff is measure from top of bitmap, we want from origin
            (hoff, voff) = (pk.hoff(c), pk.voff(c));
            # print "c=%d, offset=(%d,%d), wh=(%d,%d)" % (c, hoff, voff, w, h);
            xmin = min(xmin, -hoff);
            xmax = max(xmax, w - hoff);
            ymin = min(ymin, voff - h);
            ymax = max(ymax, voff);
      self._minmax = ((xmin, ymin), (xmax, ymax));
      self.faceWidth   = xmax - xmin + 1; # ensures > 0
      self.faceHeight  = ymax - ymin + 1; # ensures > 0

   def calcMinMaxOld(self):
      pk = self._font.pk();
      xymin = [0, 0]; xymax = [0, 0];
      for c in xrange(pk.charfirst(), pk.charlast()+1):
         if pk.haschar(c):
            bmwh = (pk.bitmapwidth(c), pk.bitmapheight(c));
            # pk.voff is measure from top of bitmap, we want from origin
            offset  = (pk.hoff(c), pk.voff(c) - bmwh[1]);
            # print "c=%d, offset=(%d,%d), voff=%d, bm=(%d,%d)" % (
            #        c, offset[0], offset[1], pk.voff(c), bmwh[0], bmwh[1]);
            for i in (0,1):
               xymin[i] = min(xymin[i], -offset[i]);
               xymax[i] = max(xymax[i], bmwh[i] - offset[i] );
      # print "xymin=", xymin, "xymax=", xymax
      self._minmax = (xymin, xymax);
      xymin = self._minmax[0];
      xymax = self._minmax[1];
      self.faceWidth   = xymax[0] - xymin[0] + 1; # ensures > 0
      self.faceHeight  = xymax[1] - xymin[1] + 1; # ensures > 0
   #
   def getNRows(self, bc, ec):
      # Each row will have 16 character places
      bRow = bc / 16;
      eRow = ec / 16;
      nRows = eRow - bRow + 1;
      return nRows;


   def drawGrid(self, placeWidth, placeHeight, nRows, itemsList):
      xb = extpad; xe = xb + 16*placeWidth;
      yb = extpad; ye = yb + nRows*placeHeight;
      # print "xb=%d, xe=%d, yb=%d, ye=%d" % (xb, xe, yb, ye);
      segment = [-1, yb, -1, ye];
      for x in range(xb, xe+1, placeWidth):
         segment[0] = segment[2] = x;
         item = self.root().add('line', points=segment,
                                fill_color='blue', width_pixels=gridwidth);
         # item.connect('event', self.callback);
         itemsList.append(item);
      segment = [xb, -1, xe, -1];
      for y in range(yb, ye+1, placeHeight):
         segment[1] = segment[3] = y;
         item = self.root().add('line', points=segment,
                                fill_color='blue', width_pixels=gridwidth);
         itemsList.append(item);


   def drawNatural(self):
      pk = self._font.pk();
      bc = pk.charfirst();
      ec = pk.charlast();
      nRows = self.getNRows(bc, ec);
      xymin = self._minmax[0];
      xymax = self._minmax[1];
      placeWidth  = self.faceWidth  + 2*intpad + gridwidth;
      placeHeight = self.faceHeight + 2*intpad + gridwidth;
      self.placeNatural = (placeWidth, placeHeight);
      self.place = self.placeNatural;
      canvWidth  = 2*extpad + 16 * placeWidth  + gridwidth;
      canvHeight = 2*extpad + nRows*placeHeight + gridwidth;
      self.naturalScroll = (canvWidth, canvHeight);
      # print "drawNatural: canvas w=%d, h=%d" % (canvWidth, canvHeight);
      self.set_scroll_region(0, 0, canvWidth, canvHeight);
      self.drawGrid(placeWidth, placeHeight, nRows, self.naturalItems);
      # Draw the charactres. Keep (x,y) as their reference point.
      x0 = extpad + gridwidth + intpad - xymin[0];
      x = x0 + (bc % 16)*placeWidth;
      # We do not need to offset the initial row with: + (bc / 16)*placeHeight
      # Even if bc >= 16, it will be displayed on top first row.
      y = extpad + gridwidth + intpad + xymax[1];
      c = bc;
      pkObj = pk.obj();
      pixbufs = self._pixbufs;
      while c <= ec:
         if pk.haschar(c):
            # print "pkObj=", pkObj, ", c=", c, ", x=", x, ", y=", y;
            cItem = pkcanvas.drawchar(self, pixbufs, c,
                                      x - pk.hoff(c), y - pk.voff(c));
            if cItem != None:
               self.naturalCItems.append(cItem);
         c = c + 1;
         if c % 16 != 0:
            x = x + placeWidth;
         else:
            x = x0;
            y = y + placeHeight;
   #
   def draw(self, selectedChar):
      self._displayMode = displayNatural;
      self.destroyFit();
      if len(self.naturalCItems): # already rendered
         self.set_scroll_region(0, 0,
                                self.naturalScroll[0], self.naturalScroll[1]);
         for i in self.naturalItems:
            i.show();
         for i in self.naturalCItems:
            pkcanvas.itemop(i, 1);
         self.place = self.placeNatural;
      else:
         self.drawNatural();
      self.drawSelect(selectedChar);
         
   def hideNatural(self):
      for i in self.naturalItems:
         i.hide();
      for i in self.naturalCItems:
         pkcanvas.itemop(i, 0);

   def draw2fit(self, selectedChar):
      self._displayMode = displayFit;
      self.destroyFit();
      self.hideNatural();
      pk = self._font.pk();
      bc = pk.charfirst();
      ec = pk.charlast();
      nRows = self.getNRows(bc, ec);
      (dumx, dumy, w, h) = self.get_allocation();
      placeWidth = (w-1 - 2*extpad) / 16;
      placeHeight = (h-1 - 2*extpad) / max(nRows, 1);
      # But we want to keep the aspect ratio of the natural space.
      # so first see the possible face space
      extra = 2*intpad + gridwidth;
      fw = max(placeWidth  - extra, 1);
      fh = max(placeHeight - extra, 1);
      # Now see which diemnsion needs to shrink.
      fhMultNatFW = fh * self.faceWidth;
      fwMultNatFH = fw * self.faceHeight;
      # print "face: (%d,%d), " % (self.faceWidth, self.faceHeight)
      # print "fw=%d, fh=%d" % (fw, fh);
      # print "fhMultNatFW=%d, fwMultNatFH=%d" % (fhMultNatFW, fwMultNatFH);
      if fhMultNatFW < fwMultNatFH:
         q = Q(fh, self.faceHeight);
         fw = q.mult(self.faceWidth);
         placeWidth = fw + extra;
      else:
         q = Q(fw, self.faceWidth);   
         fh = q.mult(self.faceHeight);
         placeHeight = fh + extra;
      self.placeFit = (placeWidth, placeHeight);
      self.place = self.placeFit;
      self.set_scroll_region(0, 0, w - 1, h - 1);
      self.drawGrid(placeWidth, placeHeight, nRows, self.fitItems);
      # Draw the charactres. Keep (x,y) as their reference point.
      xymin = self._minmax[0];
      xymax = self._minmax[1];
      x0 = extpad + gridwidth + intpad - q.mult(xymin[0]);
      x = x0 + (bc % 16)*placeWidth;
      y = extpad + gridwidth + intpad + q.mult(xymax[1]);
      c = bc;
      pkObj = pk.obj();
      pixbufs = self._pixbufs;
      while c <= ec:
         if pk.haschar(c):
            cItem = pkcanvas.drawfitchar(self, pixbufs, c,
                                         x - q.mult(pk.hoff(c)),
                                         y - q.mult(pk.voff(c)),
                                         q.mult(pk.bitmapwidth(c)),
                                         q.mult(pk.bitmapheight(c)));
            if cItem != None:
               self.fitCItems.append(cItem);
         c = c + 1;
         if c % 16 != 0:
            x = x + placeWidth;
         else:
            x = x0;
            y = y + placeHeight;
      self.drawSelect(selectedChar);

   def destroyFit(self):
      for i in self.fitItems:
         i.destroy();
      self.fitItems = []
      for i in self.fitCItems:
         pkcanvas.itemop(i, -1);
      self.fitCItems = []

   
   def callback(self, w, e=None):
      if e.type == GDK.BUTTON_RELEASE:
         # The following do not work unfortunately...
         # print " w=", self.c2w(e.x, e.y);
         # print " w2c=", self.w2c(e.x, e.y);
         wxy = pkcanvas.window2world(self, e.x, e.y);
         # print "wxy=", wxy;
         if wxy[0] > extpad and wxy[1] > extpad:
            col = (wxy[0] - extpad) / self.place[0];
            row = (wxy[1] - extpad) / self.place[1];
            c = 16 * (row + self.rowOffset()) + col;
            # print "col=", col, ", row=", row, ", c=", c;
            # print "(%d,%d), col=%d, row=%d, c=%d" % (e.x, e.y, col, row, c);
            if col < 16 and self._font.pk().haschar(c):
               self._font.select(c);
   #
   def drawSelect(self, c):
      if self._selectItem != None:
         self._selectItem.destroy();
      x0 = extpad + (c % 16) * self.place[0];
      y0 = extpad + (c / 16 - self.rowOffset()) * self.place[1];
      x1 = x0 + self.place[0];
      y1 = y0 + self.place[1];
      poly = (x0, y0,  x0, y1,  x1, y1,  x1, y0);
      self._selectItem = self.root().add('polygon', points=poly,
                                         outline_color='green',
                                         width_pixels=selectWidth);
      
   def rowOffset(self):
      return self._font.pk().charfirst() / 16;


# A convenient base class to manipulate maginified canvas
# with tfm to screen pixels transformations
class MagCanvas(gnome.ui.GnomeCanvas):
   def __init__(self, tfmpkFont):
      gnome.ui.GnomeCanvas.__init__(self);
      initGDK();
      self._tfmpkFont = tfmpkFont;
      tfm = tfmpkFont.tfm();
      pk  = tfmpkFont.pk();
      # LongInt factors
      self.hpppDS = (pk.hppp() + 0L) * tfm.headdesignsize();
      self.vpppDS = (pk.vppp() + 0L) * tfm.headdesignsize();
   # Convert tfm horizontal units to number of pixels
   def tfmh2pix(self, tfmu):
      l = (self.hpppDS * (self._mag * tfmu) + halfScaledPower) / scaledPower;
      return Long2int(l);
   def tfmv2pix(self, tfmu):
      l = (self.vpppDS * (self._mag * tfmu) + halfScaledPower) / scaledPower;
      return Long2int(l);
   # signed
   def stfmh2pix(self, tfmsu):
      if tfmsu >= 0: r = self.tfmh2pix(tfmsu);
      else:          r = -self.tfmh2pix(-tfmsu);
      return r;
   def stfmv2pix(self, tfmsu):
      if tfmsu >= 0: r =  self.tfmv2pix(tfmsu);
      else:          r = -self.tfmv2pix(-tfmsu);
      return r;


#
class FocusChar(MagCanvas):
   def __init__(self, tfmpkFont, probeOutFunc):
      MagCanvas.__init__(self, tfmpkFont);
      self.connect('event', self.callback);
      self._probeOut = probeOutFunc;
      tfm = tfmpkFont.tfm();
      pk  = tfmpkFont.pk();
      self.maxWidth = tfm.maxwidth();
      self.maxHeight = tfm.maxheight();
      self.maxDepth = tfm.maxdepth();
      params = tfm.params();
      self.slant_code = slant_code = params['slant_code'];
      self.space      = space      = params['space_code'];
      self.strech     = strech     = params['space_stretch_code'];
      self.shrink     = shrink     = params['space_shrink_code'];
      self.ex         = ex         = params['x_height_code'];
      self.quad       = quad       = params['quad_code']; # em
      self.extra      = extra      = params['extra_space_code'];
      self.preMagLeftOffset = extra + strech + space;
      self.postMagLeftOffset = space + strech;
      self.preMagWidth  = max(self.preMagLeftOffset +
                              self.maxWidth + self.postMagLeftOffset,
                              quad); 
      self.preMagHeight = max(self.maxHeight, ex);
      self.preMagTotalHeight = max(self.maxDepth + self.maxHeight, ex);
      #print "FocusChr(L): w=%d, h=%d" % (self.preMagWidth, self.preMagHeight);
      self.item = None;
      self.marksItems = [];
      self._mag = 0; # undefined
   def setMag(self, mag):
      self._mag = mag;
      ext = extpad + dimWidth + intpad;
      canvW = 2*ext + self.stfmh2pix(self.preMagWidth);
      canvH = 2*ext + self.stfmv2pix(self.preMagTotalHeight);
      self.set_scroll_region(0, 0, canvW + 1, canvH + 1);
   def draw(self, pk, c, mag=1):
      if self.item != None:
         pkcanvas.itemop(self.item, -1);
      if self._mag != mag:
         self.setMag(mag);
      hoff = self._mag * pk.hoff(c);
      voff = self._mag * pk.voff(c);
      ext = extpad + dimWidth + intpad;
      x = (ext + self.tfmh2pix(self.preMagLeftOffset) - hoff);
      y = (ext + self.tfmv2pix(self.maxHeight) - voff);
      self.item = pkcanvas.drawmagchar(self, pk.obj(), c, mag, x, y);
      self.drawMarks(c);
   #
   def drawMarks(self, c):
      for i in self.marksItems:
         i.destroy();
      (dumx, dumy, fcanvW, fcanvH) = self.get_scroll_region();
      (canvW, canvH) = (int(fcanvW), int(fcanvH));
      self.marksItems = []
      tfm = self._tfmpkFont.tfm();
      ext = extpad + dimWidth + intpad;
      self.x0 = x0 = ext + self.tfmh2pix(self.preMagLeftOffset);
      self.x1 = x1 = x0 + self.stfmh2pix(tfm.cwidth(c));
      self.y0 = y0 = ext + self.tfmv2pix(self.maxHeight);
      self.yh = yh = y0 - self.tfmv2pix(tfm.cheight(c));
      self.yd = yd = y0 + self.tfmv2pix(tfm.cdepth(c));
      # Char Bbox
      self.markPoly([x0, yh,  x0, yd,  x1, yd,  x1, yh,  x0, yh]);
      b0 = ext;
      b1 = b0 + self.tfmh2pix(self.preMagLeftOffset + tfm.cwidth(c) +
                              self.postMagLeftOffset);
      self.markPoly([b0, y0,  b1, y0]); # base line
      pixShrink   = self.tfmh2pix(self.space - self.shrink);
      pixSpace    = self.tfmh2pix(self.space);
      pixStretch  = self.tfmh2pix(self.space + self.strech);
      self.lStretch  = x0 - pixStretch;
      self.lSpace    = x0 - pixSpace;
      self.lShrink   = x0 - pixShrink;
      self.rShrink   = x1 + pixShrink;
      self.rSpace    = x1 + pixSpace;
      self.rStretch  = x1 + pixStretch;
      ph = (yd - yh + 1)/4;
      (yup, ydn) = (y0 - ph, min(y0 + ph, canvH - 1));
      # rect (het) for extra_space
      self.lExtra = b0;
      (xl, xr) = (b0, self.lStretch)
      self.markPoly([xl, y0,  xl, yup, xr, yup, xr, y0]);
      # left stretch triangle <|
      (xl, xr) = (self.lStretch, self.lSpace);
      self.markPoly([xl, y0, xr, ydn, xr, yup, xl, y0]);
      # left shrink >
      (xl, xr) = (self.lSpace, self.lShrink);
      self.markPoly([xl, ydn, xr, y0, xl, yup]);
      # right shrink <
      (xl, xr) = (self.rShrink, self.rSpace);
      self.markPoly([xr, yup, xl, y0, xr, ydn]);
      # right stretch triangle |>
      (xl, xr) = (self.rSpace, self.rStretch);
      self.markPoly([xl, ydn, xr, y0, xl, yup, xl, ydn]);
      # dx
      xl = x0 + self._mag * self._tfmpkFont.pk().dx(c);
      self.markPoly([xl, y0, xl-2, ydn, xl+2, ydn, xl, y0]);

      # quads (ems)
      (xl, xr) = (x0, x0 + self.tfmh2pix(self.quad));
      (yt, yb) = (extpad, extpad + dimWidth);
      self.temItem = self.markPoly([xr, yb, xr, yt, xl, yt, xl, yb], 'polygon');
      yb = max(canvH - extpad, ydn);
      yt = yb - dimWidth;
      self.bemItem = self.markPoly([xr, yb, xr, yt, xl, yt, xl, yb], 'polygon');
      # exs
      yb = y0;
      yt = y0 - self.tfmv2pix(self.ex);
      (xl, xr) = (extpad, extpad + dimWidth);
      self.lexItem = self.markPoly([xr, yb, xr, yt, xl, yt, xl, yb], 'polygon');
      (xl, xr) = (canvW - extpad - dimWidth, canvW - extpad);
      self.rexItem = self.markPoly([xr, yb, xr, yt, xl, yt, xl, yb], 'polygon');
                              
   def markPoly(self, pl, type='line'):
      i = self.root().add(type, points=pl,
                          fill_color='blue', width_pixels=gridwidth);
      self.marksItems.append(i);
      return i;
      
   def callback(self, w, e):
      if (e.type == GDK.BUTTON_PRESS or
          e.type == GDK.MOTION_NOTIFY and ((e.state & GDK.BUTTON1_MASK) != 0)):
         (x, y) = pkcanvas.window2world(self, e.x, e.y);
         item = self.get_item_at(x, y);
         # print "(%d,%d)" % (x, y), ", item=", item
         if   item == self.temItem  or  item == self.bemItem:
            self._probeOut("em (quad) unit length");
         elif item == self.lexItem  or  item == self.rexItem:
            self._probeOut("ex unit length");
         # The following must be consistent with drawMarks()
         elif x < self.x0:
            if x > self.lShrink:
               self._probeOut("Less than shrinked space");
            elif x > self.lSpace:
               self._probeOut("Space shrink");
            elif x > self.lStretch:
               self._probeOut("Space stretch");
            elif x > self.lExtra:
               self._probeOut("Extra space");
         elif x < self.x1:
            if y < self.y0:
               if y > self.yh:
                  self._probeOut("Inside above base");
            elif y < self.yd:
                  self._probeOut("Inside below base");
         elif x < self.rShrink:
            self._probeOut("Less than shrinked space");
         elif x < self.rSpace:
            self._probeOut("Space shrink");
         elif x < self.rStretch:
            self._probeOut("Space stretch");
      elif e.type == GDK.BUTTON_RELEASE:
         self._probeOut();


class Kern(MagCanvas):
   def __init__(self, tfmpkFont, ki):
      MagCanvas.__init__(self, tfmpkFont);
      self._mag = 0;
      self._item = None;
   def setMag(self, mag):
      self._mag = mag;
   def unshowPair(self):
      if self._item != None:
         pkcanvas.itemop(self._item, -1);
         self._item = None;
   def showPair(self, mag, c1, c2, kernActive, kernIndex):
      self._mag = mag;
      tfm = self._tfmpkFont.tfm();
      pk = self._tfmpkFont.pk();
      (w1, h1) = (pk.bitmapwidth(c1), pk.bitmapheight(c1));
      (w2, h2) = (pk.bitmapwidth(c2), pk.bitmapheight(c2));
      (hoff1, voff1) = (pk.hoff(c1), pk.voff(c1));
      (hoff2, voff2) = (pk.hoff(c2), pk.voff(c2));
      # dx = self._tfmpkFont.pk().dx(c1); # Escapement of 1st char
      dx = self._tfmpkFont.tfm().cwidth(c1); # Escapement of 1st char
      dxPixels = self.tfmh2pix(dx);
      kernVal = self._tfmpkFont.tfm().kern(kernIndex);
      kernPixels = self.tfmh2pix(kernVal);
      # We figure out the bounding box of both offset bitmaps 
      # with or without kerning. We want to avoid a window-geometry
      # change upon changing kerning mode.
      refHeight = max(voff1, voff2);
      refDepth =  max(h1 - voff1, h2 - voff2, 0);
      bbHeight = self._mag * (refHeight + refDepth);
      # Compute the x-position of the second character bitmap,
      # relative to the first. Without and with kerning.
      c1xmin = self._mag * (-hoff1);
      c1xmax = c1xmin + self._mag * w1;
      c2xmin = self._mag * (-hoff2) + dxPixels;
      c2xmax = c2xmin + self._mag * w2;
      c2xminKern = c2xmin + kernPixels;
      c2xmaxKern = c2xmax + kernPixels;
      xmin = min(c1xmin, c2xmin, c2xminKern);
      xmax = max(c1xmax, c2xmax, c2xmaxKern);
      bbWidth = xmax - xmin;
      # y-offsets
      yoff1 = self._mag * (refHeight - voff1);
      yoff2 = self._mag * (refHeight - voff2);
      self.set_scroll_region(0, 0, bbWidth + 1, bbHeight + 1);
      if self._item != None:
         pkcanvas.itemop(self._item, -1);
      c2xpos = c2xmin + kernActive * kernPixels; # logic add
      self._item = pkcanvas.drawmagpair(self, self._tfmpkFont.pk().obj(),
                                        self._mag, bbWidth, bbHeight,
                                        c1, c1xmin - xmin, yoff1,
                                        c2, c2xpos - xmin, yoff2,
                                        0, 0);
      pass;


class Exten(MagCanvas):
   def __init__(self, tfmpkFont):
      MagCanvas.__init__(self, tfmpkFont);
      self._mag = 0;
      self._item = None;
   def setMag(self, mag):
      self._mag = mag;
   def showExten(self, mag, top, mid, bot, rep, nRep):
      # print "showExten(): mag=%d, top=%d, mid=%d, bot=%d, rep=%d, nRep=%d" %(
      #       mag, top, mid, bot, rep, nRep);
      pk = self._tfmpkFont.pk();
      tmbr = [top, mid, bot, rep]; # in tfm's exten bytes order
      bmw = [0, 0, 0, 0];
      bmh = [0, 0, 0, 0];
      hoff = [0, 0, 0, 0];
      voff = [0, 0, 0, 0];
      xmin = sys.maxint;
      xmax = -sys.maxint;
      ymax = 0;
      for i in range(0,4):
         c = tmbr[i];
         if c:
            bmw[i] = pk.bitmapwidth(c);
            bmh[i] = pk.bitmapheight(c);
            hoff[i] = pk.hoff(c);
            voff[i] = pk.voff(c);
            xmin = min(xmin, -hoff[i]);
            xmax = max(xmax, bmw[i] + -hoff[i]);
            ymax = ymax + max(bmh[i], voff[i]);
      bitmapWidth = mag*(xmax - xmin + 1);
      # Since our current computation assumes one occurrence of rep part
      n = nRep - 1;
      if mid:
         n = 2*nRep - 1;
      ymax = ymax + n * max(bmh[tfm.exten_rep], voff[tfm.exten_rep]);
      bitmapHeight = mag*(ymax + 1);
      if self._item != None:
         pkcanvas.itemop(self._item, -1);
      self.set_scroll_region(0, 0, bitmapWidth + 1, bitmapHeight + 1);
      if 1:
         self._item = pkcanvas.drawmagexten(self, pk.obj(),
                                         mag, bitmapWidth, bitmapHeight,
                                         mag*xmin,
                                         top, mid, bot, rep, nRep);
