import java.awt.*;
import java.awt.event.*;

//
// InputDialog is a general purpose input dialog.  It is passed a title
// and an array of questions.  It returns a string array with responses
// to the questions.  It is arranged in a GridBagLayout to make things
// stack nicely.
//
public class InputDialog extends Dialog implements ActionListener
{
    private String[] output;
    private TextField[] tfInput;
    private String[] prompts;
    private Button m_okBut;
    private Button m_cancelBut;
    private boolean m_lhasData = false;

    // constructor.  Call the super with the passed title
    InputDialog(Frame f, String message, String[] questions, String OKBut, String CancelBut)
    {
        super(f, "Input Dialog", true);
        setBackground(Color.lightGray);
        // add message to a panel that gets to go North
        Panel nPan = new Panel(new FlowLayout());
        nPan.add(new Label(message));
        add("North", nPan);
        // add questions to one panel, and fields to another
        Panel wPan = new Panel(new GridLayout(0, 1));
        Panel cPan = new Panel(new GridLayout(0, 1));
        prompts = questions;
        output = new String[questions.length];
        tfInput = new TextField[questions.length];
        int i = 0;
        while(i < questions.length)
        {
            wPan.add(new Label(questions[i]));
            tfInput[i] = new TextField(30);
            tfInput[i].setBackground(Color.white);
            cPan.add(tfInput[i]);
            i++;
        }
        add("West", wPan);
        add("Center", cPan);
        // add panel for buttons
        Panel sPan = new Panel(new GridLayout(0, 2));
        m_okBut = new Button(OKBut);
        m_okBut.addActionListener(this);
        sPan.add(m_okBut);
        m_cancelBut = new Button(CancelBut);
        m_cancelBut.addActionListener(this);
        sPan.add(m_cancelBut);
        add("South", sPan);
        pack();
        center(f);
    }

    // isNewData() returns true if there is new data
    public boolean isNewData()
    {
        return m_lhasData;
    }

    // getNewData() returns the string array with the
    // answers to the passed questions
    public String[] getNewData()
    {
        return output;
    }
    
    /*
     ** center(Container over) centers the dialog over the passed
     ** container
     */
    public void center(Container over)
    {
        if(over.isVisible())
        {
            int width = getSize().width;
            int height = getSize().height;
            setSize(width, height);
            int parentScreenX = over.getLocationOnScreen().x;
            int parentScreenY = over.getLocationOnScreen().y;
            int parentWidth = over.getBounds().width;
            int parentHeight = over.getBounds().height;
            int screenX = Math.max(0, parentScreenX + parentWidth / 2 - width / 2);
            int screenY = Math.max(0, parentScreenY + parentHeight / 2 - height / 2);
            setLocation(screenX, screenY);
        }
    }

    // actionPerformed is where the actions are listened for
    public void actionPerformed(ActionEvent evt)
    {
        String arg = evt.getActionCommand();
        if(evt.getSource().equals(m_okBut))
        {
            // if OK, fill the output array
            m_lhasData = false;
            int i = 0;
            while(i < tfInput.length)
            {
                output[i] = new String(tfInput[i].getText());
                if(output[i].length() > 0)
                {
                    m_lhasData = true;
                }
                i++;
            }
            setVisible(false);
        }
        else
        {
            m_lhasData = false;
            setVisible(false);
        }
    }
}
